﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Runtime.Serialization;

namespace AZVIC.Ei8htPOS.Entities
{
    /// <summary>
    /// The BusinessBaseClass class serves as the base class for all business entities in the current project namespace.
    /// </summary>
    [Serializable]
    [DataContract]
    public abstract class BusinessBaseClass
    {
        [DataMember]
        public abstract Guid UniqueID { get; set; }
        [DataMember]
        public abstract GlobalConfigurations.Mode Mode { get; set; }
        [DataMember]
        public abstract DateTime CreatedDate { get; set; }
        [DataMember]
        public abstract DateTime ModifiedDate { get; set; }
        [DataMember]
        public abstract bool IsActive { get; set; }

        //public abstract bool IsDeleted { get; set; }
    }

    /// <summary>
    /// The BusinessCollectionBase class serves as the base class for all main business entity collections.
    /// It overcomes limitations of the generic Collection&lt;T&gt; class by implementing a Sort method.
    /// </summary>
    public class BusinessCollectionBase<T> : Collection<T>
    {
        /// <summary>
        /// Initializes a new instance of the BusinessCollectionBase class.
        /// </summary>
        public BusinessCollectionBase() { }

        /// <summary>
        /// Initializes a new instance of the BusinessCollectionBase class and populates it with the initial list.
        /// </summary>
        public BusinessCollectionBase(IList<T> initialList) : base(initialList) { }

        /// <summary>
        /// Sorts the collection based on the specified comparer.
        /// </summary>
        /// <param name="comparer">The comparer that is used to sort this collection.</param>
        public void Sort(IComparer<T> comparer)
        {
            if (comparer == null)
            {
                throw new ArgumentNullException("comparer", "Comparer is null.");
            }
            List<T> list = this.Items as List<T>;
            if (list == null)
            {
                return;
            }
            list.Sort(comparer);
        }
    }
}
